// Constants
const COMPANY_NAME = "TechNova Inc.";
const MAX_EMPLOYEES = 100;

// Check if an employee is full-time
function isFullTime(hoursWorked) {
    return hoursWorked >= 35;
}

// Return a string summary of an employee
function getEmployeeSummary(name, hoursWorked) {
    const status = isFullTime(hoursWorked) ? "Full-Time" : "Part-Time";
    return `${name} works at ${COMPANY_NAME} as a ${status} employee.`;
}

// Return a single employee object
function createEmployee(id, name, hoursWorked) {
    return {
        id,
        name,
        hoursWorked,
        status: isFullTime(hoursWorked) ? "Full-Time" : "Part-Time"
    };
}

// Return a list of employees
function getAllEmployees() {
    return [
        createEmployee(1, "Sanju", 40),
        createEmployee(2, "Jin", 28),
        createEmployee(3, "Alfredo", 36)
    ];
}

// Export everything (order doesn’t matter)
